WIDTH, HEIGHT = 50, 20

class Player:
    def __init__(self, name, posX, posY, level):
        self._name = name
        self._posX = posX
        self._posY = posY
        self._level = level
    @property
    def name(self):
        return self._name
    @property
    def posX(self):
        return self._posX
    @property
    def posY(self):
        return self._posY
    @property
    def level(self):
        return self._level

    def left(self):
        if self._posX > 0:
            self._posX -= 1

    def right(self):
        if self._posX < WIDTH-1:
            self._posX += 1

    def up(self):
        if self._posY > 0:
            self._posY -= 1

    def down(self):
        if self._posY < HEIGHT-1:
            self._posY += 1


class Players:
    def __init__(self, player_list = [], player_factory = Player): #creating objects is evil in business logic - we inject a factory
        self._players = {player.name: player for player in player_list} #map nicer access
        self._player_factory = player_factory

    def player(self, name):
        return self._players[name]
    
    def players(self):
        return (item[1] for item in self._players.items())

    def go(self, name):
        if name not in self._players:
            self._players[name] = self._player_factory(name, WIDTH//2, HEIGHT//2, 1)

            
    def left(self, name):
        self._players[name].left()

    def right(self, name):
        self._players[name].right()

    def up(self, name):
        self._players[name].up()

    def down(self, name):
        self._players[name].down()
    
